// Change to match your package
package demo;

/**
 *
 * @author Runner Technologies Technical Staff
 * Version: 2012-10-24-01
 * 
 */
/**
 * ***************************************************************************************
 *
 * Package Name : CleanAddress
 *
 * Description : Wrapper package for CLEAN_Address for isolating specific fields
 * to pass to the verification request
 *
 * This package is meant to be copied or modified for your specific
 * implementation
 *
 * NOTE: This is very useful for Java implementations since Java can map easier
 *       to primitive datatypes rather than PL/SQL record structures
 *
 *****************************************************************************************
 * Copyright (c) 2004 Runner Technologies, Inc. All Rights Reserved.
 * www.RunnerTechnologies.com (877)784-0003 561-395-9322
 ****************************************************************************************
 */
import java.sql.*;

////////////////////////////////////////////////////////////////////////////
//
// Call the CLEAN_Address.Verify procedure through a Java CallableStatement
//
////////////////////////////////////////////////////////////////////////////
public class VerifyAddress {
    ////////////////////////////////////////////////////////////////////
    // public strings to initialize before calling verify()
    //

    public static String address_name;
    public static String address_1;
    public static String address_2;
    public static String city;
    public static String state_province;
    public static String postal_code;
    public static String country_code;
    public static String telephone_number;
    public static String telephone_format;
    public static String address_status_code;
    public static String address_error_code;
    public static String dpv_status_code;
    public static String formatted_address_1;
    public static String formatted_address_2;
    public static String formatted_address_3;
    public static String formatted_address_4;
    public static String gender;
    public static int telephone_distance;
    public static float latitude;
    public static float longitude;
    public static String fv_plsql_return_code;
    public static String fv_plsql_return_description;

    ////////////////////////////////////////////////////////////////////
    // Constructor
    //
    public void VerifyAddress() {
        reset();
    }

    ////////////////////////////////////////////////////////////////////
    // Reset all public variables - INPUT and OUTPUT
    //
    public void reset() {
        address_name = "";
        address_1 = "";
        address_2 = "";
        city = "";
        state_province = "";
        postal_code = "";
        country_code = "";
        telephone_number = "";
        telephone_format = "";
        // Reset the output variables
        resetOutput();
    }

    ////////////////////////////////////////////////////////////////////
    // Reset all OUTPUT public variables
    //
    public static void resetOutput() {
        address_status_code = "";
        address_error_code = "";
        dpv_status_code = "";
        formatted_address_1 = "";
        formatted_address_2 = "";
        formatted_address_3 = "";
        formatted_address_4 = "";
        gender = "";
        telephone_distance = -1;
        latitude = -1;
        longitude = -1;
        fv_plsql_return_code = "";
        fv_plsql_return_description = "";
    }

    ////////////////////////////////////////////////////////////////////
    // Get a string value - if null, return ""
    //
    public String getString(String str) {
        return (str == null) ? "" : str;
    }

    ////////////////////////////////////////////////////////////////////
    // Get a string value for a float - if -1, return ""
    //
    public String getString(float num) {
        if (num == -1) {
            return "";
        } else {
            Float fNum = new Float(num);
            return fNum.toString();
        }
    }

    ////////////////////////////////////////////////////////////////////
    // Get a string value for an integer - if -1, return ""
    //
    public String getString(int num) {
        if (num == -1) {
            return "";
        } else {
            Integer iNum = new Integer(num);
            return iNum.toString();
        }
    }

    ////////////////////////////////////////////////////////////////////
    // Call the CLEAN_Address.Verify procedure
    //
    public static void verify() throws SQLException {
        //
        // Initialize the output variables so null doesn't get returned
        //
        System.out.println("Resetting output...");
        resetOutput();

        //
        // PL/SQL block to execute the CLEAN_Address Wrapper package
        //
        System.out.println("Creting sql...");
        String sql = "BEGIN CLEAN_Address_Wrapper.Verify("
                + " ? " + //address_name
                ",? " + //address_1
                ",? " + //address_2
                ",? " + //city
                ",? " + //state_province
                ",? " + //postal_code
                ",? " + //country_code
                ",? " + //telephone_number
                ",? " + //telephone_format
                ",? " + //address_status_code
                ",? " + //address_error_code
                ",? " + //dpv_status_code - Delivery Point Validation
                ",? " + //formatted_address_1
                ",? " + //formatted_address_2
                ",? " + //formatted_address_3
                ",? " + //formatted_address_4
                ",? " + //gender
                ",? " + //telephone_distance
                ",? " + //latitude
                ",? " + //longitude
                ",? " + //fv_plsql_return_code
                ",? " + //fv_plsql_return_description
                " ); END;";

        // Database connection
        Connection con = null;
        // Create the Callable Statement for the PL/SQL block above
        CallableStatement stmt = null;

        try {
            //
            // Connect to the database
            // NOTE: Tes
            String dbUserid = "clnaddr";
            String dbPassword = "clnaddr";
            //String dbURL      = "jdbc:oracle:thin:@127.0.0.1:1521:runr";
            String dbURL = "jdbc:oracle:thin:@10.0.0.23:1521:csdmo";
            
            //
            // NOTE: Tested with ojdbc14.jar
            //
            String className = "oracle.jdbc.driver.OracleDriver";

            System.out.println("Connecting to database...");
            Class.forName(className);
            con = DriverManager.getConnection(dbURL, dbUserid, dbPassword);

            //
            // Prepare the statement
            //
            System.out.println("Preparing sql statement...");
            stmt = con.prepareCall(sql);

            //
            // Set all INPUT parameters
            //
            stmt.setString(1, address_name);
            stmt.setString(2, address_1);
            stmt.setString(3, address_2);
            stmt.setString(4, city);
            stmt.setString(5, state_province);
            stmt.setString(6, postal_code);
            stmt.setString(7, country_code);
            stmt.setString(8, telephone_number);
            stmt.setString(9, telephone_format);

            //
            // Register all OUTPUT parameters
            //
            stmt.registerOutParameter(1, Types.VARCHAR);
            stmt.registerOutParameter(2, Types.VARCHAR);
            stmt.registerOutParameter(3, Types.VARCHAR);
            stmt.registerOutParameter(4, Types.VARCHAR);
            stmt.registerOutParameter(5, Types.VARCHAR);
            stmt.registerOutParameter(6, Types.VARCHAR);
            stmt.registerOutParameter(7, Types.VARCHAR);
            stmt.registerOutParameter(8, Types.VARCHAR);
            //stmt.registerOutParameter(9,  Types.VARCHAR);
            stmt.registerOutParameter(10, Types.VARCHAR);
            stmt.registerOutParameter(11, Types.VARCHAR);
            stmt.registerOutParameter(12, Types.VARCHAR);
            stmt.registerOutParameter(13, Types.VARCHAR);
            stmt.registerOutParameter(14, Types.VARCHAR);
            stmt.registerOutParameter(15, Types.VARCHAR);
            stmt.registerOutParameter(16, Types.VARCHAR);
            stmt.registerOutParameter(17, Types.VARCHAR);
            stmt.registerOutParameter(18, Types.INTEGER);
            stmt.registerOutParameter(19, Types.FLOAT);
            stmt.registerOutParameter(20, Types.FLOAT);
            stmt.registerOutParameter(21, Types.VARCHAR);
            stmt.registerOutParameter(22, Types.VARCHAR);

            //
            // Execute the statement
            //
            System.out.println("Executing: [" + sql + "]");
            stmt.executeUpdate();

            //
            // Get the return values
            //
            address_name = stmt.getString(1);
            address_1 = stmt.getString(2);
            address_2 = stmt.getString(3);
            city = stmt.getString(4);
            state_province = stmt.getString(5);
            postal_code = stmt.getString(6);
            country_code = stmt.getString(7);
            telephone_number = stmt.getString(8);
            address_status_code = stmt.getString(10);
            address_error_code = stmt.getString(11);
            dpv_status_code = stmt.getString(12);
            formatted_address_1 = stmt.getString(13);
            formatted_address_2 = stmt.getString(14);
            formatted_address_3 = stmt.getString(15);
            formatted_address_4 = stmt.getString(16);
            gender = stmt.getString(17);
            telephone_distance = stmt.getInt(18);
            latitude = stmt.getFloat(19);
            latitude = (latitude == 0) ? -1 : latitude;
            longitude = stmt.getFloat(20);
            longitude = (longitude == 0) ? -1 : longitude;
            fv_plsql_return_code = stmt.getString(21);
            fv_plsql_return_description = stmt.getString(22);

        } catch (SQLException ex) {
            ex.printStackTrace();
        } catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException ex) {
                    ex.printStackTrace();
                }

            }
            if (con != null) {
                try {
                    con.close();
                } catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("Start clnaddr VerifyAddress");
        try {

            address_1 = "6530 w rogers";
            address_2 = "";
            city = "boca raton";
            state_province = "FL";
            postal_code = "";
            country_code = "";
            telephone_number = "";
            telephone_format = "";

            verify();
            
            
           //Print/Display the results
            
            System.out.println("=====================================================");
            System.out.println("\naddress_1 = "+ address_1);
            System.out.println("address_2 = "+address_2);
            System.out.println("city = "+city);
            System.out.println("state_province = "+state_province);
            System.out.println("postal_code = "+postal_code);
            System.out.println("country_code = "+country_code);
            System.out.println("address_status_code = "+address_status_code);
            System.out.println("address_error_code = "+address_error_code);
            System.out.println("dpv_status_code = "+dpv_status_code);
            System.out.println("latitude = "+latitude);
            System.out.println("latitude = "+latitude);
            System.out.println("longitude = "+longitude);
            System.out.println("longitude = "+longitude);
            System.out.println("fv_plsql_return_code = "+fv_plsql_return_code);
            System.out.println("fv_plsql_return_description = "+fv_plsql_return_description);            
            
            
            
        } catch (Exception e) {;
        }
    }
}
